/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.util;

import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDisk;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskProvider;
import com.raoulvdberge.refinedstorage.api.storage.tracker.StorageTrackerEntry;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.gui.grid.stack.GridStackFluid;
import com.raoulvdberge.refinedstorage.gui.grid.stack.GridStackItem;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public final class StackUtils {
    public static final ItemStack EMPTY_BUCKET = new ItemStack(Items.field_151133_ar);
    private static final String NBT_INVENTORY = "Inventory_%d";
    private static final String NBT_SLOT = "Slot";
    private static final String NBT_ITEM_TYPE = "Type";
    private static final String NBT_ITEM_QUANTITY = "Quantity";
    private static final String NBT_ITEM_DAMAGE = "Damage";
    private static final String NBT_ITEM_NBT = "NBT";
    private static final String NBT_ITEM_CAPS = "Caps";

    public static void writeItemStack(ByteBuf buf, @Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeInt(Item.func_150891_b((Item)stack.func_77973_b()));
            buf.writeInt(stack.func_190916_E());
            buf.writeShort(stack.func_77952_i());
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)stack.func_77973_b().getNBTShareTag(stack));
        }
    }

    public static ItemStack readItemStack(ByteBuf buf) {
        if (!buf.readBoolean()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = new ItemStack(Item.func_150899_d((int)buf.readInt()), buf.readInt(), (int)buf.readShort());
        stack.func_77982_d(ByteBufUtils.readTag((ByteBuf)buf));
        return stack;
    }

    public static void writeItemGridStack(ByteBuf buf, ItemStack stack, long count, UUID id, @Nullable UUID otherId, boolean craftable, @Nullable StorageTrackerEntry entry) {
        StackUtils.writeItemStack(buf, stack);
        StackUtils.writeGridStack(buf, count, id, otherId, craftable, entry);
    }

    public static void writeFluidGridStack(ByteBuf buf, FluidStack stack, long realCount, UUID id, @Nullable UUID otherId, boolean craftable, @Nullable StorageTrackerEntry entry) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)stack.writeToNBT(new NBTTagCompound()));
        StackUtils.writeGridStack(buf, realCount, id, otherId, craftable, entry);
    }

    private static void writeGridStack(ByteBuf buf, long count, UUID id, @Nullable UUID otherId, boolean craftable, @Nullable StorageTrackerEntry entry) {
        buf.writeLong(count);
        buf.writeBoolean(craftable);
        buf.writeLong(id.getMostSignificantBits());
        buf.writeLong(id.getLeastSignificantBits());
        buf.writeBoolean(otherId != null);
        if (otherId != null) {
            buf.writeLong(otherId.getMostSignificantBits());
            buf.writeLong(otherId.getLeastSignificantBits());
        }
        if (entry == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeLong(entry.getTime());
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getName());
        }
    }

    public static GridStackItem readItemGridStack(ByteBuf buf) {
        ItemStack stack = StackUtils.readItemStack(buf);
        long realCount = buf.readLong();
        boolean craftable = buf.readBoolean();
        UUID id = new UUID(buf.readLong(), buf.readLong());
        UUID otherId = null;
        if (buf.readBoolean()) {
            otherId = new UUID(buf.readLong(), buf.readLong());
        }
        StorageTrackerEntry entry = null;
        if (buf.readBoolean()) {
            entry = new StorageTrackerEntry(buf.readLong(), ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
        return new GridStackItem(id, otherId, stack, realCount, craftable, entry);
    }

    public static GridStackFluid readFluidGridStack(ByteBuf buf) {
        FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)ByteBufUtils.readTag((ByteBuf)buf));
        long realCount = buf.readLong();
        boolean craftable = buf.readBoolean();
        UUID id = new UUID(buf.readLong(), buf.readLong());
        UUID otherId = null;
        if (buf.readBoolean()) {
            otherId = new UUID(buf.readLong(), buf.readLong());
        }
        StorageTrackerEntry entry = null;
        if (buf.readBoolean()) {
            entry = new StorageTrackerEntry(buf.readLong(), ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
        return new GridStackFluid(id, otherId, stack, realCount, entry, craftable);
    }

    public static ItemStack nullToEmpty(@Nullable ItemStack stack) {
        return stack == null ? ItemStack.field_190927_a : stack;
    }

    @Nullable
    public static ItemStack emptyToNull(@Nullable ItemStack stack) {
        return stack == null || stack.func_190926_b() ? null : stack;
    }

    public static void createStorages(World world, ItemStack diskStack, int slot, IStorageDisk<ItemStack>[] itemDisks, IStorageDisk<FluidStack>[] fluidDisks, Function<IStorageDisk<ItemStack>, IStorageDisk> itemDiskWrapper, Function<IStorageDisk<FluidStack>, IStorageDisk> fluidDiskWrapper) {
        if (diskStack.func_190926_b()) {
            itemDisks[slot] = null;
            fluidDisks[slot] = null;
        } else {
            IStorageDisk<?> disk = API.instance().getStorageDiskManager(world).getByStack(diskStack);
            if (disk != null) {
                switch (((IStorageDiskProvider)diskStack.func_77973_b()).getType()) {
                    case ITEM: {
                        itemDisks[slot] = itemDiskWrapper.apply(disk);
                        break;
                    }
                    case FLUID: {
                        fluidDisks[slot] = fluidDiskWrapper.apply(disk);
                    }
                }
            } else {
                itemDisks[slot] = null;
                fluidDisks[slot] = null;
            }
        }
    }

    public static void writeItems(IItemHandler handler, int id, NBTTagCompound tag) {
        StackUtils.writeItems(handler, id, tag, stack -> stack.func_77955_b(new NBTTagCompound()));
    }

    public static void writeItems(IItemHandler handler, int id, NBTTagCompound tag, Function<ItemStack, NBTTagCompound> serializer) {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).func_190926_b()) continue;
            NBTTagCompound stackTag = serializer.apply(handler.getStackInSlot(i));
            stackTag.func_74768_a(NBT_SLOT, i);
            tagList.func_74742_a((NBTBase)stackTag);
        }
        tag.func_74782_a(String.format(NBT_INVENTORY, id), (NBTBase)tagList);
    }

    public static void writeItems(IInventory inventory, int id, NBTTagCompound tag) {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (inventory.func_70301_a(i).func_190926_b()) continue;
            NBTTagCompound stackTag = new NBTTagCompound();
            stackTag.func_74768_a(NBT_SLOT, i);
            inventory.func_70301_a(i).func_77955_b(stackTag);
            tagList.func_74742_a((NBTBase)stackTag);
        }
        tag.func_74782_a(String.format(NBT_INVENTORY, id), (NBTBase)tagList);
    }

    public static void readItems(IItemHandlerModifiable handler, int id, NBTTagCompound tag) {
        StackUtils.readItems(handler, id, tag, ItemStack::new);
    }

    public static void readItems(IItemHandlerModifiable handler, int id, NBTTagCompound tag, Function<NBTTagCompound, ItemStack> deserializer) {
        String name = String.format(NBT_INVENTORY, id);
        if (tag.func_74764_b(name)) {
            NBTTagList tagList = tag.func_150295_c(name, 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                int slot = tagList.func_150305_b(i).func_74762_e(NBT_SLOT);
                if (slot < 0 || slot >= handler.getSlots()) continue;
                handler.setStackInSlot(slot, deserializer.apply(tagList.func_150305_b(i)));
            }
        }
    }

    public static void readItems(IInventory inventory, int id, NBTTagCompound tag) {
        String name = String.format(NBT_INVENTORY, id);
        if (tag.func_74764_b(name)) {
            NBTTagList tagList = tag.func_150295_c(name, 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                int slot = tagList.func_150305_b(i).func_74762_e(NBT_SLOT);
                ItemStack stack = new ItemStack(tagList.func_150305_b(i));
                if (stack.func_190926_b()) continue;
                inventory.func_70299_a(slot, stack);
            }
        }
    }

    public static boolean hasFluidBucket(FluidStack stack) {
        return stack.getFluid() == FluidRegistry.WATER || stack.getFluid() == FluidRegistry.LAVA || stack.getFluid().getName().equals("milk") || FluidRegistry.getBucketFluids().contains(stack.getFluid());
    }

    public static FluidStack copy(FluidStack stack, int size) {
        FluidStack copy = stack.copy();
        copy.amount = size;
        return copy;
    }

    public static Pair<ItemStack, FluidStack> getFluid(ItemStack stack, boolean simulate) {
        if (stack.func_190916_E() > 1) {
            stack = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1);
        }
        if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            IFluidHandlerItem fluidHandler = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            FluidStack result = fluidHandler.drain(1000, !simulate);
            return Pair.of((Object)fluidHandler.getContainer(), (Object)result);
        }
        return Pair.of(null, null);
    }

    public static NBTTagCompound serializeStackToNbt(@Nonnull ItemStack stack) {
        NBTTagCompound dummy = new NBTTagCompound();
        NBTTagCompound itemTag = new NBTTagCompound();
        itemTag.func_74768_a(NBT_ITEM_TYPE, Item.func_150891_b((Item)stack.func_77973_b()));
        itemTag.func_74768_a(NBT_ITEM_QUANTITY, stack.func_190916_E());
        itemTag.func_74768_a(NBT_ITEM_DAMAGE, stack.func_77952_i());
        if (stack.func_77942_o()) {
            itemTag.func_74782_a(NBT_ITEM_NBT, (NBTBase)stack.func_77978_p());
        }
        stack.func_77955_b(dummy);
        if (dummy.func_74764_b("ForgeCaps")) {
            itemTag.func_74782_a(NBT_ITEM_CAPS, dummy.func_74781_a("ForgeCaps"));
        }
        dummy.func_82580_o("ForgeCaps");
        return itemTag;
    }

    @Nonnull
    public static ItemStack deserializeStackFromNbt(NBTTagCompound tag) {
        ItemStack stack = new ItemStack(Item.func_150899_d((int)tag.func_74762_e(NBT_ITEM_TYPE)), tag.func_74762_e(NBT_ITEM_QUANTITY), tag.func_74762_e(NBT_ITEM_DAMAGE), tag.func_74764_b(NBT_ITEM_CAPS) ? tag.func_74775_l(NBT_ITEM_CAPS) : null);
        stack.func_77982_d(tag.func_74764_b(NBT_ITEM_NBT) ? tag.func_74775_l(NBT_ITEM_NBT) : null);
        return stack;
    }
}

